﻿using System;
using System.Web;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using System.Linq;
using AntiXssEnc = Microsoft.Security.Application;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class FragLabOrder : EfrBasePage
    {
        //LabOrderManager manager = new LabOrderManager();
        //WKF_CASE_ACTIVITY activity;

        private WKF_CASE_ACTIVITY Activity
        {
            get
            {
                WKF_CASE_ACTIVITY activity = null;

                if (ViewState["Activity"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["Activity"] = activity;
                }
                else
                {
                    activity = ViewState["Activity"] as WKF_CASE_ACTIVITY;
                }

                return activity;
            }
            set
            {
                ViewState["Activity"] = value;
            }
        }

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/LabOrders/LabOrders.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        public FragLabOrder()
        {
            //Manager Save Notification Event Handler
            //manager.BOSaveSuccess += Manager_BOSaveSuccess;

            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            //ReplacePageTitle();

            if (!IsPostBack)
            {
                int orderId;
                if (int.TryParse(Request.QueryString["activityId"], out orderId))
                {
                    GetRefreshLabOrder(orderId);
                    ViewState["ReferralCaseId"] = Activity.WKF_CASE.REFERRAL_ID;
                    //only for biological
                    if (Activity.STD_WKFACTIVITYTYPE_ID == 3)
                        SetupFragLabOrder();
                }

                SetReferringPage();
            }

            RangeValidatorLabRequestDateIsDate.MaximumValue =
            RangeValidatorLabelSampleReceivedDateIsDate.MaximumValue = DateTime.Today.ToShortDateString();
        }

        private void GetRefreshLabOrder(int oId)
        {
            Activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, oId);
            //Activity = manager.getLabOrderByOrderID(oId);
            //Activity.SetAsChangeTrackingRoot();

            //BreadCrumbLabel.Text = "Interpretation & Follow Up > " + activityStatus.NAME + " > Workflow ID " + wCase.WKF_CASE_ID;
            ReplacePageTitle("My Tasks > Lab Orders > " + Activity.STD_WKFACTIVITYSTS.NAME + " > Workflow ID : " + Activity.WKF_CASE_ID.ToString());
        }

        private void SetupFragLabOrder()
        {
            lblSampleType.Text = "FRAGMENT";

            List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
            //if (Activity.LAB_ORDERs.Count > 0)
            if (orders != null && orders.Count > 0)
            {
                LAB_ORDER order = orders.First();
                //LAB_ORDER order = Activity.LAB_ORDERs.First();

                var shortDate = order.LAB_SEND_DATE.HasValue ? order.LAB_SEND_DATE.Value.ToString("yy") : DateTime.Today.ToString("yy");
                var tempText = shortDate + " - " + "TEF" + order.LAB_ORDER_ID.ToString().PadLeft(5, '0');
                lblLabRequestNumber.Text = AntiXssEnc.Encoder.HtmlEncode(tempText);

                if (order.LAB_SEND_DATE.HasValue)
                    LabRequestDate.Text = order.LAB_SEND_DATE.Value.ToShortDateString();
                else
                {
                    if (Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided)
                        LabRequestDate.Text = String.Empty;
                    else
                        LabRequestDate.Text = DateTime.Now.ToShortDateString();
                }
                if (order.LAB_RECEIVED_DATE.HasValue)
                    LabSampleReceivedDate.Text = order.LAB_RECEIVED_DATE.Value.ToShortDateString();

                if (order.LAB_RETURN_DATE.HasValue)
                {
                    tempText = order.LAB_RETURN_DATE.Value.ToShortDateString();
                    LabelLabReportDate.Text = AntiXssEnc.Encoder.HtmlEncode(tempText);
                }
            }
            else
                LabRequestDate.Text = DateTime.Today.ToString("d");

            switch (Activity.STD_WKFACTIVITYSTS_ID)
            {
                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New:
                    LabelForLabLabelReportDate.Visible = false;
                    LabelLabReportDate.Visible = false;
                    SaveButton.Enabled = false;
                    CompleteButton.Enabled = true;
                    VoidButton.Enabled = true;
                    SaveButton.Text = "Save";

                    RequiredFieldValidatorLabRequestDate.Enabled = true;

                    SaveButton.ValidationGroup = "";

                    break;

                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.AwaitingResults:
                    LabelForLabLabelReportDate.Visible = false;
                    LabelLabReportDate.Visible = false;
                    SaveButton.Enabled = true;
                    CompleteButton.Enabled = false;
                    VoidButton.Enabled = false;
                    SaveButton.Text = "Save";

                    RequiredFieldValidatorLabRequestDate.Enabled = true;

                    SaveButton.ValidationGroup = "LabOrderValidation";

                    break;

                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Closed:
                    CompleteButton.Enabled = false;
                    SaveButton.Enabled = false;
                    VoidButton.Enabled = false;
                    LabelForLabLabelReportDate.Visible = true;
                    LabelLabReportDate.Visible = true;
                    SaveButton.Text = "Save";
                    RequiredFieldValidatorLabRequestDate.Enabled = true;

                    SaveButton.ValidationGroup = "";

                    break;

                //void status
                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided:
                    SaveButton.Enabled = true;
                    CompleteButton.Enabled = false;
                    VoidButton.Enabled = false;
                    LabelForLabLabelReportDate.Visible = false;
                    LabelLabReportDate.Visible = false;
                    SaveButton.Text = "Un-Void";
                    RequiredFieldValidatorLabRequestDate.Enabled = false;

                    SaveButton.ValidationGroup = "LabOrderValidation";

                    break;
            }
        }

        private void SaveCompleteLabOrder(Func<string> operation)
        {
            LAB_ORDER order;
            List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
            //if (Activity.LAB_ORDERs.Count > 0)
            if (orders != null && orders.Count > 0)
            {
                order = orders.First();
                //order = Activity.LAB_ORDERs.First();

                SaveLabOrder(ref order);
            }
            else
            {
                order = new LAB_ORDER();

                SaveLabOrder(ref order);

                //Activity.LAB_ORDERs.Add(order);
            }
            //set questionnaire in-process status

            Activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity);
            //manager.Update(Activity);

            order.WKF_CASE_ACTIVITY_ID = Activity.WKF_CASE_ACTIVITY_ID;
            order.LAB_ORDER_ID = VIRP.EFR.BLL.LAB_ORDERManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, order);

            WKF_CASE wkfCase = ServiceInterfaceManager.WKF_CASE_GET_BY_ACTIVITY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
            if (wkfCase != null)
            {
                OpenCloseReferralAndWorkflowCase(wkfCase, operation);
            }

            //FormViewBreadCrumb.DataBind();
            GetRefreshLabOrder(Activity.WKF_CASE_ACTIVITY_ID);
        }

        //this is the function that gets all values from page controls to eventually save them in a database  
        private void SaveLabOrder(ref LAB_ORDER labOrder)
        {
            labOrder.LAB_SEND_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRequestDate.Text.Trim());
            labOrder.LAB_RECEIVED_DATE = Helpers.ConvertStringToNullable<DateTime>(LabSampleReceivedDate.Text.Trim());
            labOrder.LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(LabelLabReportDate.Text.Trim());

            //EFR registry
            labOrder.STD_REGISTRY_ID = 1;
        }

        //protected override void LoadViewState(object savedState)
        //{
        //    base.LoadViewState(savedState);
        //    string activityXml = (string)ViewState["activityXml"];
        //    Activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activityXml);
        //}

        //protected override object SaveViewState()
        //{
        //    ViewState["activityXml"] = Activity.Serialize();
        //    return base.SaveViewState();
        //}

        protected void SaveButton_Click(object sender, EventArgs e)
        {
            if (Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided)
            {
                Activity.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New;
            }

            SaveCompleteLabOrder(() => "Save");
            SetupFragLabOrder();

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        protected void CancelButton_Click(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }

        protected void CompleteButton_Click(object sender, EventArgs e)
        {
            //_activity.STD_WKFACTIVITYSTS_ID = 2;
            Activity.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.AwaitingResults;

            bool labResultExists = ActivityExists(Activity.WKF_CASE_ID, WorkFlowActivityTypes.LabResult);

            if (!labResultExists)
            {
                WKF_CASE_ACTIVITY NewActivity = new WKF_CASE_ACTIVITY();
                NewActivity.WKF_CASE_ID = Activity.WKF_CASE_ID;
                NewActivity.CREATED = NewActivity.UPDATED = DateTime.Now;
                NewActivity.CREATEDBY = NewActivity.UPDATEDBY = CurrentUser;
                NewActivity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(WorkFlowActivityTypes.LabResult);
                NewActivity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.New);
                NewActivity.REPRESENTATIVE_NAME = Activity.REPRESENTATIVE_NAME;
                NewActivity.CONTACT_NAME = Activity.CONTACT_NAME;
                //NewActivity.SetAsChangeTrackingRoot(EntityState.New, true);
                //NewActivity.SetAsInsertOnSubmit();

                NewActivity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, NewActivity);
                //manager.Update(NewActivity);
            }

            SaveCompleteLabOrder(() => "Complete");

            SetupFragLabOrder();

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        protected void VoidButton_Click(object sender, EventArgs e)
        {
            LabRequestDate.Text = "";
            LabSampleReceivedDate.Text = "";

            Activity.STD_WKFACTIVITYSTS_ID = 3;

            SaveCompleteLabOrder(() => "Void");

            SetupFragLabOrder();

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
        {
            //Copied this code from LabKitDetails

            VIRP_WEB.SoaServices.REFERRAL parentReferral = ServiceInterfaceManager.REFERRAL_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentCase.REFERRAL_ID.GetValueOrDefault());
            if (parentReferral != null)
            {
                if (operation() == "Void")
                {
                    List<WKF_CASE> cases = ServiceInterfaceManager.WKF_CASE_GET_ALL_BY_REFERRAL(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentReferral.REFERRAL_ID);
                    if (cases != null)
                    {
                        bool blnIncomplete = false;
                        foreach (WKF_CASE c in cases)
                        {
                            if (c.WKF_CASE_ID != parentCase.WKF_CASE_ID && c.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed)
                            {
                                blnIncomplete = true;
                                break;
                            }
                        }
                        if (!blnIncomplete)
                            parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;
                    }

                    parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
                }
                else
                {
                    if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
                        parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;

                    if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
                        parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
                }

                SuppressSaveSuccessMessage = true;
                parentCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentCase);
                parentReferral.REFERRAL_ID = ServiceInterfaceManager.REFERRAL_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentReferral);

                SuppressSaveSuccessMessage = false;
            }
        }

        //private void OpenCloseReferralAndWorkflowCase(Func<string> operation)
        //{
        //    ReferralManager rm = new ReferralManager();
        //    //WorkflowManager wfm = new WorkflowManager();
        //    int wfCaseRefId;
        //    if (int.TryParse(ViewState["ReferralCaseId"].ToString(), out wfCaseRefId))
        //    {
        //        EFR_REFERRAL parentReferral = rm.getReferralByReferralID(wfCaseRefId);

        //        parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
        //        parentReferral.SetAsChangeTrackingRoot();

        //        WKF_CASE parentCase = parentReferral.WKF_CASEs.Where(a => a.WKF_CASE_ID == Activity.WKF_CASE_ID).First();

        //        if (operation() == "Void")
        //        {
        //            //close workflow case
        //            parentCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
        //            var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

        //            //if all cases are closed close referral as well
        //            if (items.Where(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed).Count() == 0)

        //                parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;
        //        }
        //        else
        //        {
        //            if (parentReferral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
        //                parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;

        //            if (parentCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
        //                parentCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;
        //        }

        //        SuppressSaveSuccessMessage = true;
        //        rm.Update(parentReferral);

        //        SuppressSaveSuccessMessage = false;
        //    }
        //}

        private bool ActivityExists(int wkfId, WorkFlowActivityTypes type)
        {
            List<WKF_CASE_ACTIVITY> activityList = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wkfId);
            if (activityList != null)
            {
                return activityList.Where(e => e.STD_WKFACTIVITYTYPE_ID == (int)type && e.ARCHIVED_FLAG == false).Any();
            }

            return false;

            //using (_db = GetDataContext())
            //{
            //    return (_db.WKF_CASE_ACTIVITies.Where(e => e.WKF_CASE_ID == wkfId
            //        && e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(type)
            //        && e.ARCHIVED_FLAG == false
            //        ).Select(t => t.WKF_CASE_ACTIVITY_ID).Any());
            //}
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}